#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "TSS_API.h" /* include Touch Sense Software header file */

UINT8 u8TouchCount;
UINT8 u8ReleaseCount;


void MCU_Init(void) 
{
    SOPT1 = 0b00100011;              /* Disable COP, Enable Reset, Enable BKGD/MS */              
     
	/* Configures FEI mode, BUSCLK = 10 MHz */   
    
    ICSC1 = 0b00000110;              
    ICSC2 = 0b00000000; 

     
    ICSSC |= ICSSC_DMX32_MASK;       /* Maximum frequency with 32.768 kHz reference */
    
    while(ICSC1_CLKS!=ICSSC_CLKST);  /* Waits for the frequency to be configure within the MCU */

          /* Enable Bus clock of the MCU peripherals */
      
    SCGC1 = 0b11111111;   	
    SCGC2 = 0b11111111;

    PINPS3 = PINPS3_SDA_MASK|PINPS3_SCL_MASK;  /* Selects IIC module pins (OPTIONAL)*/
}

void fCallBack0 (UINT8 u8CtrlId)          /* Callback function */
{
    static UINT8 u8Key;   /* Local Variable to store the event information */
    
    while (!TSS_KEYPAD_BUFFER_EMPTY(cKey0)) /* While unread events in the buffer */
    {
	      TSS_KEYPAD_BUFFER_READ(u8Key,cKey0);/* Read the buffer */
	      if (u8Key & 0x80)      /* If the event was a release */
          {
            u8ReleaseCount++;   /* Increment the Release Count */
          }
        else
          {
            u8TouchCount++;     /* Otherwise increment the Touch count */
          }
        
    }
    
   
}

void main(void) {

    MCU_Init();         	  /* Initializes MCU Peripherals */ 
    PTFDD_PTFDD7 = 1;  //set LED on PortF bit 7 to output
    PTGDD_PTGDD6 = 1;  //Extra Credit -- set LED on Port G bit 6 as output
    
    (void)TSS_Init();
    
    (void)TSS_SetSystemConfig(System_Sensitivity_Register,0x20);
    (void)TSS_SetSystemConfig(System_Sensitivity_Register+1,0x10);//Extra Credit
    
    
    //(void)TSS_KeypadConfig(cKey0.ControlId,Keypad_Events_Register, 
    //  TSS_KEYPAD_TOUCH_EVENT_EN_MASK|TSS_KEYPAD_RELEASE_EVENT_EN_MASK);
      
    (void)TSS_KeypadConfig(cKey0.ControlId,Keypad_Events_Register, 0x3);
      
    
    (void)TSS_KeypadConfig(cKey0.ControlId,Keypad_ControlConfig_Register,
      TSS_KEYPAD_CONTROL_EN_MASK|TSS_KEYPAD_CALLBACK_EN_MASK);
    
    //
    (void)TSS_KeypadConfig(cKey0.ControlId,Keypad_MaxTouches_Register,
      2);
    //
    
    (void)TSS_SetSystemConfig(System_SystemConfig_Register, TSS_SYSTEM_EN_MASK);
    	
    EnableInterrupts; 	  /* Enable interrupts */
    
    
    for(;;) {
      TSS_Task();
      if(tss_au8ElectrodeStatus[0] == 0x01) PTFD_PTFD7=0; /* turn on LED if touched */
        else PTFD_PTFD7=1;  /* Otherwise turn it off */
    
    //Next two lines are Extra Credit
      if(tss_au8ElectrodeStatus[0] == 0x02 ) PTGD_PTGD6=0; /* turn on LED if touched */
        else PTGD_PTGD6=1;  /* Otherwise turn it off */

        __RESET_WATCHDOG(); /* feeds the dog */
    } /* loop forever */
     /* please make sure that you never leave main */
}

